/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ProxyUtils;
import org.geysermc.floodgate.util.ReflectionUtils;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class SpigotDataHandler
extends CommonDataHandler {
    private static final Property DEFAULT_TEXTURE_PROPERTY = new Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTcxNTcxNzM1NTI2MywKICAicHJvZmlsZUlkIiA6ICIyMWUzNjdkNzI1Y2Y0ZTNiYjI2OTJjNGEzMDBhNGRlYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJHZXlzZXJNQyIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS8zMWY0NzdlYjFhN2JlZWU2MzFjMmNhNjRkMDZmOGY2OGZhOTNhMzM4NmQwNDQ1MmFiMjdmNDNhY2RmMWI2MGNiIgogICAgfQogIH0KfQ", "dFKIZ5d6vNqCSe1IFGiVLjt3cnW8qh4qNP2umg9zqkX9bvAQawuR1iuO1kCD/+ye8A6GQFv2wRCdxdrjp5+Vrr0SsWqMnsYDN8cEg6CD18mAnaKI1TYDuGbdJaqLyGqN5wqSMdHxchs9iovFkde5ir4aYdvHkA11vOTi11L4kUzETGzJ4iKVuZOv4dq+B7wFAWqp4n8QZfhixyvemFazQHlLmxnuhU+jhpZMvYY9MAaRAJonfy/wJe9LymbTe0EJ8N+NwZQDrEUzgfBFo4OIGDqRZwvydInCqkjhPMtHCSL25VOKwcFocYpRYbk4eIKM4CLjYlBiQGki+XKsPaljwjVhnT0jUupSf7yraGb3T0CsVBjhDbIIIp9nytlbO0GvxHu0TzYjkr4Iji0do5jlCKQ/OasXcL21wd6ozw0t1QZnnzxi9ewSuyYVY9ErmWdkww1OtCIgJilceEBwNAB8+mhJ062WFaYPgJQAmOREM8InW33dbbeENMFhQi4LIO5P7p9ye3B4Lrwm20xtd9wJk3lewzcs8ezh0LUF6jPSDQDivgSKU49mLCTmOi+WZh8zKjjxfVEtNZON2W+3nct0LiWBVsQ55HzlvF0FFxuRVm6pxi6MQK2ernv3DQl0hUqyQ1+RV9nfZXTQOAUzwLjKx3t2zKqyZIiNEKLE+iAXrsE=");
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private Object networkManager;
    private FloodgatePlayer player;
    private boolean proxyData;

    public SpigotDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute, SpigotVersionSpecificMethods versionSpecificMethods) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
        this.versionSpecificMethods = versionSpecificMethods;
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ReflectionUtils.setValue(this.networkManager, ClassNames.SOCKET_ADDRESS, (Object)newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) throws IllegalStateException {
        if (ClassNames.IS_PRE_1_20_2) {
            ReflectionUtils.setValue(handshakePacket, ClassNames.HANDSHAKE_HOST, (Object)hostname);
            return handshakePacket;
        }
        try {
            Object[] components = new Object[]{ClassNames.HANDSHAKE_PROTOCOL.get(handshakePacket), hostname, ClassNames.HANDSHAKE_PORT.get(handshakePacket), ClassNames.HANDSHAKE_INTENTION.get(handshakePacket)};
            return ClassNames.HANDSHAKE_PACKET_CONSTRUCTOR.newInstance(components);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create new Handshake packet", e);
        }
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        this.proxyData = ProxyUtils.isProxyData();
        if (!this.proxyData) {
            ReflectionUtils.setValue(this.networkManager, "spoofedUUID", (Object)this.player.getCorrectUniqueId());
        }
        return this.proxyData && ClassNames.PAPER_DISABLE_USERNAME_VALIDATION == null;
    }

    @Override
    protected boolean shouldCallFireRead(Object queuedPacket) {
        try {
            if (this.checkAndHandleLogin(queuedPacket)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean channelRead(Object packet) throws Exception {
        if (ClassNames.HANDSHAKE_PACKET.isInstance(packet)) {
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, (String)ReflectionUtils.getCastedValue(packet, ClassNames.HANDSHAKE_HOST));
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) throws Exception {
        if (ClassNames.LOGIN_START_PACKET.isInstance(packet)) {
            Object packetListener = ClassNames.PACKET_LISTENER.get(this.networkManager);
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                this.disconnect(packetListener, kickMessage);
                return true;
            }
            if (!ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            if (ClassNames.PAPER_DISABLE_USERNAME_VALIDATION != null) {
                ReflectionUtils.setValue(packetListener, ClassNames.PAPER_DISABLE_USERNAME_VALIDATION, (Object)true);
                if (this.proxyData) {
                    this.ctx.pipeline().remove((ChannelHandler)this);
                    return false;
                }
            }
            Property texturesProperty = null;
            if (!this.player.isLinked()) {
                texturesProperty = DEFAULT_TEXTURE_PROPERTY;
            }
            GameProfile gameProfile = this.versionSpecificMethods.createGameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername(), texturesProperty);
            if (ClassNames.IS_PRE_1_20_2) {
                Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
                ReflectionUtils.setValue(packetListener, ClassNames.LOGIN_PROFILE, (Object)gameProfile);
                ClassNames.INIT_UUID.invoke(packetListener, new Object[0]);
                ClassNames.FIRE_LOGIN_EVENTS.invoke(loginHandler, new Object[0]);
            } else if (!ClassNames.IS_POST_LOGIN_HANDLER) {
                Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
                ClassNames.FIRE_LOGIN_EVENTS_GAME_PROFILE.invoke(loginHandler, gameProfile);
            } else {
                ClassNames.CALL_PLAYER_PRE_LOGIN_EVENTS.invoke(packetListener, gameProfile);
                ClassNames.START_CLIENT_VERIFICATION.invoke(packetListener, gameProfile);
            }
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    private void disconnect(Object packetListener, String kickMessage) throws Exception {
        if (ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
            ClassNames.LOGIN_DISCONNECT.invoke(packetListener, kickMessage);
        } else {
            ClassNames.NETWORK_EXCEPTION_CAUGHT.invoke(this.networkManager, this.ctx, new IllegalStateException(kickMessage));
        }
    }
}

