/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.player.HostnameSeparationResult;
import org.geysermc.floodgate.shadow.com.google.common.collect.Queues;

public abstract class CommonDataHandler
extends ChannelInboundHandlerAdapter {
    protected final FloodgateHandshakeHandler handshakeHandler;
    protected final FloodgateConfig config;
    protected final AttributeKey<String> kickMessageAttribute;
    protected final PacketBlocker blocker;
    protected final Queue<Object> packetQueue = Queues.newConcurrentLinkedQueue();
    protected Object handshakePacket;
    protected ChannelHandlerContext ctx;

    protected abstract void setNewIp(Channel var1, InetSocketAddress var2);

    protected abstract Object setHostname(Object var1, String var2);

    protected abstract boolean channelRead(Object var1) throws Exception;

    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        return true;
    }

    protected boolean shouldCallFireRead(Object queuedPacket) {
        return true;
    }

    protected void handle(Object handshakePacket, String hostname) {
        this.handshakePacket = handshakePacket;
        HostnameSeparationResult separation = this.handshakeHandler.separateHostname(hostname);
        if (separation.floodgateData() == null) {
            this.disablePacketQueue(true);
            return;
        }
        if (separation.headerVersion() != 0) {
            this.disablePacketQueue(true);
            this.setKickMessage(String.format("Received an unsupported Floodgate data version. This Floodgate version is made for data version %s, received %s. Make sure that Floodgate is up-to-date.", 0, separation.headerVersion()));
            return;
        }
        this.blocker.enable();
        Channel channel = this.ctx.channel();
        ((CompletableFuture)this.handshakeHandler.handle(channel, separation.floodgateData(), separation.hostnameRemainder()).thenApply(result -> {
            HandshakeData handshakeData = result.getHandshakeData();
            InetSocketAddress newIp = result.getNewIp(channel);
            if (newIp != null) {
                this.setNewIp(channel, newIp);
            }
            this.handshakePacket = this.setHostname(handshakePacket, handshakeData.getHostname());
            if (handshakeData.shouldDisconnect()) {
                this.setKickMessage(handshakeData.getDisconnectReason());
                return this.shouldRemoveHandler((FloodgateHandshakeHandler.HandshakeResult)result);
            }
            switch (result.getResultType()) {
                case EXCEPTION: {
                    this.setKickMessage("An internal error happened while handling Floodgate data. Try logging in again or contact a server administrator if the issue persists.");
                    break;
                }
                case DECRYPT_ERROR: {
                    this.setKickMessage(this.config.getDisconnect().getInvalidKey());
                    break;
                }
                case INVALID_DATA_LENGTH: {
                    this.setKickMessage(this.config.getDisconnect().getInvalidArgumentsLength());
                    break;
                }
            }
            return this.shouldRemoveHandler((FloodgateHandshakeHandler.HandshakeResult)result);
        })).handle((shouldRemove, error) -> {
            if (error != null) {
                error.printStackTrace();
            }
            this.disablePacketQueue((boolean)shouldRemove);
            return shouldRemove;
        });
    }

    protected void disablePacketQueue(boolean removeSelf) {
        Object queuedPacket;
        if (this.handshakePacket != null && this.shouldCallFireRead(this.handshakePacket)) {
            this.ctx.fireChannelRead(this.handshakePacket);
        }
        while ((queuedPacket = this.packetQueue.poll()) != null) {
            if (!this.shouldCallFireRead(queuedPacket)) continue;
            this.ctx.fireChannelRead(queuedPacket);
        }
        if (removeSelf) {
            this.removeSelf();
        }
        this.blocker.disable();
    }

    protected void removeSelf() {
        this.ctx.pipeline().remove((ChannelHandler)this);
    }

    protected final void setKickMessage(String message) {
        this.ctx.channel().attr(this.kickMessageAttribute).set((Object)message);
    }

    protected final String getKickMessage() {
        return (String)this.ctx.channel().attr(this.kickMessageAttribute).get();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    public void channelRead(ChannelHandlerContext ctx, Object packet) {
        if (!this.packetQueue.isEmpty()) {
            this.packetQueue.add(packet);
            return;
        }
        try {
            if (this.channelRead(packet)) {
                ctx.fireChannelRead(packet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (this.config.isDebug()) {
            cause.printStackTrace();
        }
    }

    public CommonDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute, PacketBlocker blocker) {
        this.handshakeHandler = handshakeHandler;
        this.config = config;
        this.kickMessageAttribute = kickMessageAttribute;
        this.blocker = blocker;
    }
}

