/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.bus.impl;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.PostOrder;
import org.geysermc.event.bus.OwnedEventBus;
import org.geysermc.event.bus.impl.BaseBusImpl;
import org.geysermc.event.subscribe.OwnedSubscriber;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.event.subscribe.Subscriber;
import org.geysermc.floodgate.shadow.com.google.common.collect.HashMultimap;
import org.geysermc.floodgate.shadow.com.google.common.collect.Multimaps;
import org.geysermc.floodgate.shadow.com.google.common.collect.SetMultimap;

public abstract class OwnedEventBusImpl<O, E, S extends OwnedSubscriber<O, ? extends E>>
extends BaseBusImpl<E, S>
implements OwnedEventBus<O, E, S> {
    private final SetMultimap<O, Subscriber<?>> ownedSubscribers = Multimaps.synchronizedSetMultimap(HashMultimap.create());

    protected abstract <L, T extends E, B extends OwnedSubscriber<O, T>> B makeSubscription(@NonNull O var1, @NonNull Class<T> var2, @NonNull Subscribe var3, @NonNull L var4, @NonNull BiConsumer<L, T> var5);

    protected abstract <T extends E, B extends OwnedSubscriber<O, T>> B makeSubscription(@NonNull O var1, @NonNull Class<T> var2, @NonNull Consumer<T> var3, @NonNull PostOrder var4);

    @Override
    public <T extends E, U extends OwnedSubscriber<O, T>> @NonNull U subscribe(@NonNull O owner, @NonNull Class<T> eventClass, @NonNull Consumer<T> handler) {
        return this.subscribe(owner, eventClass, handler, PostOrder.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends E, U extends OwnedSubscriber<O, T>> @NonNull U subscribe(@NonNull O owner, @NonNull Class<T> eventClass, @NonNull Consumer<T> handler, @NonNull PostOrder postOrder) {
        Object subscription = this.makeSubscription(owner, eventClass, handler, postOrder);
        SetMultimap<O, Subscriber<?>> setMultimap = this.ownedSubscribers;
        synchronized (setMultimap) {
            if (this.ownedSubscribers.put(owner, (Subscriber<?>)subscription)) {
                ((BaseBusImpl)this).register(eventClass, subscription);
            }
            return (U)subscription;
        }
    }

    @Override
    public void register(@NonNull O owner, @NonNull Object listener) {
        this.findSubscriptions(listener, (eventClass, subscribe, handler) -> {
            Object subscriber = this.makeSubscription(owner, (Class)eventClass, (Subscribe)subscribe, (Object)listener, (BiConsumer)handler);
            ((BaseBusImpl)this).register(eventClass, subscriber);
            this.ownedSubscribers.put(owner, (Subscriber<?>)subscriber);
        });
    }

    @Override
    public void unregisterAll(@NonNull O owner) {
        this.unsubscribeMany(OwnedEventBusImpl.castGenericSet(this.ownedSubscribers.removeAll(owner)));
    }

    @Override
    public <T extends E> @NonNull Set<? extends OwnedSubscriber<O, T>> subscribers(@NonNull Class<T> eventClass) {
        return Collections.unmodifiableSet(this.eventSubscribers(eventClass));
    }
}

