/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.updater.file.yaml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geysermc.configutils.updater.change.Changes;
import org.geysermc.configutils.updater.file.ConfigFileUpdater;
import org.geysermc.configutils.updater.file.ConfigFileUpdaterResult;
import org.geysermc.configutils.util.Utils;
import org.geysermc.floodgate.shadow.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.geysermc.floodgate.shadow.it.unimi.dsi.fastutil.ints.IntIntPair;

public class YamlConfigFileUpdater
implements ConfigFileUpdater {
    @Override
    public ConfigFileUpdaterResult update(Map<String, Object> currentVersion, Changes changes, Collection<String> ignore, Collection<String> copyDirectly, List<String> configTemplate) {
        ArrayList<String> updated = new ArrayList<String>(configTemplate);
        HashMap<String, Object> newVersion = new HashMap<String, Object>(currentVersion);
        HashSet<String> notFound = new HashSet<String>();
        ArrayList<String> changed = new ArrayList<String>();
        int linesRead = this.update(currentVersion, changes, ignore, copyDirectly, configTemplate, 0, 0, 0, "", 0, updated, newVersion, notFound, changed).leftInt();
        if (configTemplate.size() != linesRead) {
            return ConfigFileUpdaterResult.failed(new IllegalStateException(String.format("Failed to read the full config! Only read %s lines while config is %s lines long", linesRead, configTemplate.size())));
        }
        return ConfigFileUpdaterResult.ok(updated, newVersion, notFound, changed);
    }

    private IntIntPair update(Map<String, Object> currentVersion, Changes changes, Collection<String> ignore, Collection<String> copyDirectly, List<String> configTemplate, int startIndex, int indexOffset, int spaces, String path, int parents, List<String> updated, Map<String, Object> newVersion, Set<String> notFound, List<String> changed) {
        boolean shouldCopyDirectly = copyDirectly.contains(path);
        boolean hasCopiedDirectly = false;
        for (int i = startIndex; i < configTemplate.size(); ++i) {
            String trimmed;
            int splitIndex;
            String line = configTemplate.get(i);
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            StringBuilder lineSpaces = new StringBuilder();
            while (line.charAt(lineSpaces.length()) == ' ') {
                lineSpaces.append(' ');
            }
            if (parents > 0 && spaces >= lineSpaces.length()) {
                return new IntIntImmutablePair(i - startIndex, indexOffset);
            }
            if (shouldCopyDirectly && !hasCopiedDirectly) {
                String correctName = path.substring(0, path.length() - 1);
                String oldName = changes.oldKeyName(correctName);
                Object value = this.currentVersion(currentVersion, oldName);
                if (value == null) {
                    notFound.add(correctName);
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new IllegalStateException("I can only copy sections directly! " + correctName);
                }
                indexOffset = this.writeMap(i, indexOffset, lineSpaces.length(), path, (Map)value, newVersion, updated);
                hasCopiedDirectly = true;
                continue;
            }
            if (line.charAt(lineSpaces.length()) == '#' || (splitIndex = (trimmed = line.trim()).indexOf(58)) == -1) continue;
            if (this.isStartSubcategory(trimmed, splitIndex)) {
                String subcategoryName = trimmed.substring(0, splitIndex);
                String newPath = path + subcategoryName + ".";
                IntIntPair result = this.update(currentVersion, changes, ignore, copyDirectly, configTemplate, i + 1, indexOffset, lineSpaces.length(), newPath, parents + 1, updated, newVersion, notFound, changed);
                i += result.leftInt();
                indexOffset = result.rightInt();
                continue;
            }
            String name = trimmed.substring(0, splitIndex);
            String correctName = path + name;
            if (ignore.contains(correctName)) continue;
            String oldName = changes.oldKeyName(correctName);
            Object value = this.currentVersion(currentVersion, oldName);
            if (value == null) {
                notFound.add(correctName);
                continue;
            }
            if ((value = changes.newValue(correctName, value)) instanceof String) {
                value = "\"" + value + "\"";
            }
            changed.add(correctName);
            updated.set(i + indexOffset, lineSpaces + name + ": " + value);
            this.setNewVersion(newVersion, correctName, value);
        }
        return new IntIntImmutablePair(configTemplate.size(), indexOffset);
    }

    private boolean isStartSubcategory(String trimmed, int splitIndex) {
        String substring = trimmed.substring(splitIndex + 1).trim();
        if (substring.isEmpty()) {
            return true;
        }
        for (int i = 0; i < substring.length(); ++i) {
            char charAt = substring.charAt(i);
            if (charAt == '#') {
                return true;
            }
            if (charAt == ' ') continue;
            return false;
        }
        return true;
    }

    private Object currentVersion(Map<String, Object> currentVersion, String correctName) {
        Map curSubcategory = currentVersion;
        String[] parts = correctName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            if ((curSubcategory = (Map)curSubcategory.get(parts[i])) != null) continue;
            return null;
        }
        return curSubcategory.get(parts[parts.length - 1]);
    }

    public void setNewVersion(Map<String, Object> newVersion, String correctName, Object value) {
        Map<String, Object> curSubcategory = newVersion;
        String[] parts = correctName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            HashMap<String, Object> newSubcategory = (HashMap<String, Object>)curSubcategory.get(parts[i]);
            if (newSubcategory != null) continue;
            newSubcategory = new HashMap<String, Object>();
            curSubcategory.put(parts[i], newSubcategory);
            curSubcategory = newSubcategory;
        }
        curSubcategory.put(parts[parts.length - 1], value);
    }

    private int writeMap(int index, int indexOffset, int spaces, String path, Map<String, Object> map, Map<String, Object> newVersion, List<String> updated) {
        int entriesHandled = 0;
        String prefix = Utils.repeat(' ', spaces);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                updated.add(index + indexOffset, prefix + entry.getKey() + ':');
                ++indexOffset;
                indexOffset = this.writeMap(index + entriesHandled, indexOffset, spaces + 2, path + entry.getKey() + ".", (Map)entry.getValue(), newVersion, updated);
                continue;
            }
            updated.add(index + indexOffset, prefix + entry.getKey() + ": " + entry.getValue());
            this.setNewVersion(newVersion, path + entry.getKey(), entry.getValue());
            ++indexOffset;
        }
        return indexOffset;
    }
}

